#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;

struct Move {
    long double ang;
    int x, y, idx;
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<Move> moves(n);
    for (int i = 0; i < n; ++i) {
        int x, y;
        cin >> x >> y;
        long double ang = atan2l(y, x);
        if (ang < 0) ang += 2 * M_PI;
        moves[i] = {ang, x, y, i + 1};
    }

    sort(moves.begin(), moves.end(), [](const Move& a, const Move& b) {
        return a.ang < b.ang;
    });

    vector<Move> a(2 * n);
    for (int i = 0; i < n; ++i) {
        a[i] = moves[i];
        a[i + n] = moves[i];
        a[i + n].ang = moves[i].ang + 2 * M_PI;
    }

    int l = 0, r = 0;
    long long sum_x = 0, sum_y = 0;
    long long best_norm_sq = -1;
    int best_l = 0, best_r = -1;

    for (int l = 0; l < n; ++l) {
        if (r < l) {
            r = l;
            sum_x = 0;
            sum_y = 0;
        }
        while (r < 2 * n && a[r].ang - a[l].ang < M_PI - 1e-12L) {
            sum_x += a[r].x;
            sum_y += a[r].y;
            ++r;
        }

        long long norm_sq = sum_x * sum_x + sum_y * sum_y;
        if (norm_sq > best_norm_sq) {
            best_norm_sq = norm_sq;
            best_l = l;
            best_r = r - 1;
        }

        sum_x -= a[l].x;
        sum_y -= a[l].y;
    }

    vector<int> indices;
    for (int i = best_l; i <= best_r; ++i) {
        indices.push_back(a[i].idx);
    }
    sort(indices.begin(), indices.end());

    cout << indices.size() << '\n';
    for (size_t i = 0; i < indices.size(); ++i) {
        if (i > 0) cout << ' ';
        cout << indices[i];
    }
    cout << '\n';

    return 0;
}